function vicOnMapKey(args)
{
    var key = args.k;
    var mod = args.m;
}

function vicAfterMapLoad(args)
{
var map = args.map;
vicPreloadMapEffectsOnFlag(map, "map_preload_effects");
}

// for a list of specified tile coordinates, apply a list of effects to each tile. Tile effects are applied on the tile, unit effects to all tile occupants
function vicPreloadMapEffectsOnFlag(map, flag)
{
if (flag == null) return;
var line = map.ScriptFlags.get(flag);
if (line == null) return;
var line = line.split("; "); // user input
var preloads = new Array(); // contains tokenized content

for (var i=0; i<line.length; i++)
{
var tempArray = line[i].split(" = ");
for (var j=0; j<tempArray.length; j++)
preloads.push(tempArray[j]); 
}
// at this point, even indices of preloads contains coordinates, odd the rest of the information for the previous index's tile coord

for (var i=0; i<preloads.length; i+=2)
{
var coordString = preloads[i].split(", "); // split something like 5, 6 into individual numbers
var x = parseInt(coordString[0]);
var y = parseInt(coordString[1]);
if (vicIsValidCoord(x-1, y-1) == false) throw "map_preload_effects: " + x + ", " + y + " is not a valid coordinate for  this map. Processing aborted."; // decrement x and y because users specified coords starting from 1
x--; y--;

var effects = preloads[i+1].split(", "); // subarrays of preloads[i+1] has unparsed effect names, wich may or may not have durations
var tile = shared.Map.GetTile(x, y);

vicApplyEffectsToTileOccupants(tile, effects);
vicApplyMultipleTileEffects(effects, tile);
}
}

// return a boolean, determining if the given coordinates are valid for the map
// coordinates need to be 0-based (i.e 0,0 is the top left corner)
function vicIsValidCoord(x, y)
{
if (x == null || y == null || x < 0 || y < 0 || x >= shared.Map.Width || y >= shared.Map.Height) return false;
return true;
}

function vicAfterTurnEnded(args) 
{
    var units = args.ending_units; // a list of units on the team that is ending their turn.
}

function vicAfterTurnStarted(args) 
{
    var units = args.starting_units; // a list of units on the team that is starting their turn.
}

function vicOverrideHandleCausers(args) 
{
    // this function is responsible for dealing all damage and healing for any skill, item, or effect
    var effecter = args.effecter; // the skill, item, or effect causing damage or healing.
    var skill = args.skill; // the effecter, if it is a skill
    var item = args.item; // the effecter, if it is an item
    var effect = args.effect; // the effecter, if it is an effect
    var unit = args.cur_unit; // the unit using the skill or item, if any
    var target = args.target_unit; // the target of the skill, item, or effect
    var targetTile = args.target_tile; // the tile being effected, if in TB combat
    return { handled: true }; // handled indicates this script decided to handle it and the engine should not do any further perform skill logic.
}

function vicOverrideTbTeamAi(args) 
{
    var units = args.units; // the list of units that need their AI run.
    var friends = args.friends;
    var enemies = args.enemies;
    return { handled: true }; // handled indicates this script decided to handle it and the engine should not do any further AI logic for this team.
}

function vicOverrideTbUnitAi(args) 
{
    // This method will get called multiple times for each unit until all units report that they did not do anything.
    // If the override_tb_team_ai event is handled then this function will never get called as the team level AI supersedes this logic.
    var unit = args.unit; // the single unit that needs it's AI run.
    var friends = args.friends;
    var enemies = args.enemies;
    return { handled: true, did_something: true }; // handled indicates this script decided to handle it and the engine should not do any further AI logic for this unit.
    // did_something indicates whether this unit performed an action or not.
}

